package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;

/**
 * 导入案件人员关系
 * 
 * @author qsh
 *
 * @2019年3月1日
 */
@Data
@NoArgsConstructor
public class CasePersonResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   * 
   * @see CaseUserTypeEnum
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   * 
   * @see UserTypeEnum
   */
  private String userType;
  private String userName;
  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;

}
