package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * package: com.beiming.odr.referee.dto.responsedto describe: 文书列表响应对象 create_user: xiet
 * create_date: 2019/1/31 create_time: 2:27 PM
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DocumentListResDTO implements Serializable {

  private static final long serialVersionUID = -1812103711651250647L;
  /**
   * 文书ID
   */
  private Long documentId;

  /**
   * 文书名称
   */
  private String documentName;

  /**
   * 发送状态
   */
  private String sendStatus;

  /**
   * 文书类型
   */
  private String documentType;

  /**
   * 会议ID获取调解笔录和调查笔录用
   */
  private String meetingId;

  /**
   * 文书参会人员列表
   */
  private String userIdStr;

  /**
   * 会议类型
   */
  private String meetingType;

  /**
   * 笔录前缀
   */
  private String docNamePrefix;

  /**
   * 文书状态
   */
  private Integer status;

  public DocumentListResDTO(Long documentId, String documentName, String sendStatus,
      String documentType, String meetingId, String userIdStr, String meetingType,
      String docNamePrefix) {
    this.documentId = documentId;
    this.documentName = documentName;
    this.sendStatus = sendStatus;
    this.documentType = documentType;
    this.meetingId = meetingId;
    this.userIdStr = userIdStr;
    this.meetingType = meetingType;
    this.docNamePrefix = docNamePrefix;
  }
}
