package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件与用户关系
 *
 * @author qsh
 * @data 2018年7月10日
 */
@Data
@NoArgsConstructor
public class LawCasePersonResDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 案件号
   */
  private String caseNum;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 代理人id
   */
  private String agentId;
}
