package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 获取异议书的响应对象
 * 
 * @author DJQ 2018年7月8日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationDissentGetResDTO implements Serializable {

  private static final long serialVersionUID = 2763857461448263390L;

  private Long lawCaseId; // 案件号
  private Long documentId; // 文书号
  private Long personnelId; // Personnel主键
  private String caseUserType; // 用户案件角色
  private String userName; // 用户名称
  private String userType; // 用户类型
  private String sex; // 性别
  private String phone; // 电话号
  private String idCard; // 身份证号
  private String provCode; // 省Code
  private String cityCode; // 市Code
  private String areaCode; // 区Code
  private String streetCode; // 街道Code
  private String provName; // 省Name
  private String cityName; // 市Name
  private String areaName; // 区Name
  private String streetName; // 街Name
  private String address; // 地址
  private String content; // 文本内容
  /**
   * 其它联系电话
   */
  private String contactPhone;

  /**
   * 代理人固定电话
   */
  private String agentTelephone;

  public MediationDissentGetResDTO(CaseProtocolPersonnelResDTO person) {
    this.documentId = person.getDocumentId();
    this.personnelId = person.getPersonnelId(); // Personnel主键
    this.caseUserType = person.getCaseUserType();
    this.userType = person.getUserType();
    this.userName = person.getUserName(); // 用户名称
    this.sex = person.getSex(); // 性别
    this.phone = person.getPhone(); // 电话号
    this.idCard = person.getIdCard(); // 身份证号
    this.provCode = person.getProvCode(); // 省Code
    this.cityCode = person.getCityCode(); // 市Code
    this.areaCode = person.getAreaCode(); // 区Code
    this.streetCode = person.getStreetCode(); // 街道Code
    this.provName = person.getProvName(); // 省Name
    this.cityName = person.getCityName(); // 市Name
    this.areaName = person.getAreaName(); // 区Name
    this.streetName = person.getStreetName(); // 街Name
    this.address = person.getAddress(); // 地址
    this.contactPhone = person.getContactPhone();
    this.agentTelephone = person.getAgentTelephone();
  }

}
