package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 待参与视频列表
 * 
 * @author chenjt
 * @date 2019年1月31日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WaitCaseMeetingListResDTO implements Serializable {


  private static final long serialVersionUID = -239888032581127069L;

  /**
   * 会议id
   */
  private Long meetingId;
  /**
   * 视频房间id(m.meeting_video_id)
   */
  private String roomId;

  /**
   * 会议类型
   */
  private String meetingType;

  /**
   * 会议状态
   */
  private String meetingStatus;

  /**
   * 会议预约时间
   */
  private Date orderTime;

  /**
   * 会议开始时间
   */
  private Date startTime;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  /**
   * 机构名称
   */
  private String orgName;


  /**
   * 申请人
   */
  private List<String> applyUserList;


  /**
   * 被申请人
   */
  private List<String> respondentUserList;


}
