package com.beiming.odr.referee.enums;

/**
 * @Description: 文书类型枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum DocumentTypeEnum {
  MEDIATION_BOOK("调解协议书"), COMMITMENT_BOOK("无异议调解方案承诺书"), NO_DISSENT_MEDIATION_SCHEME(
      "无异议调解方案"), UNDISPUTED_FACT("无争议事实确认协议"), MEDIATION_RECORD("调解笔录"), INQUIRE_RECORD(
          "调查笔录"), DISSENT_RECORD("异议书"), JUDICIAL_CONFIRM_APPLY_BOOK("司法确认申请书"),
  MEDIATION_APPLY_BOOK("调解申请书");

  private String name;

  DocumentTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 判断是否为笔录类型文书
   * 
   * @param documentType
   * @return
   */
  public static Boolean isRecord(String documentType) {
    return DocumentTypeEnum.MEDIATION_RECORD.name().equalsIgnoreCase(documentType)
        || DocumentTypeEnum.INQUIRE_RECORD.name().equalsIgnoreCase(documentType);
  }

}
