package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.SaveJudicialConfirmBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveProtocolBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.WaitSignDocumentReqDTO;
import com.beiming.odr.referee.dto.responsedto.DocumentListResDTO;
import com.beiming.odr.referee.dto.responsedto.JudicialConfirmBookResDTO;
import com.beiming.odr.referee.dto.responsedto.MediatorHelpPersonResDTO;
import com.beiming.odr.referee.dto.responsedto.ProtocolBookResDTO;
import com.beiming.odr.referee.dto.responsedto.UnanimityMediationSchemeResDTO;
import com.beiming.odr.referee.dto.responsedto.WaitSignDocumentResDTO;
import com.beiming.odr.referee.enums.DocumentTypeEnum;
import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/**
 * @Description: 文书api接口
 * @Author: caiwei
 * @Date: Created 2018-06-20
 */
@RequestMapping(RefereeApiConst.URL_PREFIX + "/document")
@RestController
public interface DocumentApi {

  /**
   * 判断文书是否存在
   */
  @RequestMapping(value = "/checkDocumentExist", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> checkDocumentExist(@RequestParam(name = "id") Long id);

  /**
   * 获取协议书
   */
  @RequestMapping(value = "/getProtocolBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ProtocolBookResDTO> getProtocolBook(@RequestParam(name = "caseId") Long caseId,
      @RequestBody DocumentTypeEnum documentTypeEnum);

  /**
   * 获取备份协议书
   */
  @RequestMapping(value = "/getTempProtocolBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ProtocolBookResDTO> getTempProtocolBook(@RequestParam(name = "caseId") Long caseId,
      @RequestBody DocumentTypeEnum documentTypeEnum);

  /**
   * 保存协议书
   */
  @RequestMapping(value = "/saveProtocolBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ProtocolBookResDTO> saveProtocolBook(@RequestBody @Valid SaveProtocolBookReqDTO dto);

  /**
   * 保存调解笔录
   */
  @RequestMapping(value = "/saveRecordBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ProtocolBookResDTO> saveRecordBook(@RequestBody @Valid SaveProtocolBookReqDTO dto);

  /**
   * 保存异议书
   */
  @RequestMapping(value = "/saveDissentBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ProtocolBookResDTO> saveDissentBook(@RequestBody @Valid SaveProtocolBookReqDTO dto);

  /**
   * 发送协议书
   */
  @RequestMapping(value = "/sendProtocolBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult sendProtocolBook(@RequestParam(name = "documentId") Long documentId);

  /**
   * 获取调解方案
   */
  @RequestMapping(value = "/getMediationScheme", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<UnanimityMediationSchemeResDTO> getMediationScheme(@RequestParam(name = "caseId") Long caseId);

  /**
   * 保存承诺书
   */
  @RequestMapping(value = "/savePromiseBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult savePromiseBook(@RequestBody SavePromiseBookReqDTO dto);

  /**
   * 拒绝文书
   */
  @RequestMapping(value = "/refuseDocument", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> refuseDocument(@RequestParam(name = "documentId") Long documentId,
      @RequestParam(name = "confirmUserId") Long confirmUserId,
      @RequestParam(name = "userName") String userName);

  /**
   * 获取案件调解员id
   */
  @RequestMapping(value = "/getMediationIdByCaseId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> getMediationIdByCaseId(@RequestParam(name = "caseId") Long caseId);

  /**
   * 获取司法确认申请书
   */
  @RequestMapping(value = "/getJudicialConfirmBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<JudicialConfirmBookResDTO> getJudicialConfirmBook(
      @RequestParam(name = "caseId") Long caseId, @RequestBody DocumentTypeEnum documentTypeEnum,
      @RequestParam(name = "isNew") Integer isNew);

  /**
   * 保存司法确认申请书
   */
  @RequestMapping(value = "/saveJudicialConfirmBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> saveJudicialConfirmBook(@RequestBody SaveJudicialConfirmBookReqDTO dto);

  /**
   * 发送司法确认申请书
   */
  @RequestMapping(value = "/sendJudicialConfirmBook", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> sendJudicialConfirmBook(@RequestBody SaveJudicialConfirmBookReqDTO dto);

  /**
   * 根据文书id返回案件id
   */
  @RequestMapping(value = "/getCaseIdByDocId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> getCaseIdByDocId(@RequestParam(name = "id") Long id);

  /**
   * 待确认文书列表
   */
  @RequestMapping(value = "/getWaitSignDocumentList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<WaitSignDocumentResDTO>> getWaitSignDocumentList(
      @RequestBody WaitSignDocumentReqDTO reqDTO);

  /**
   * 通过案件ID查询文书列表
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/getAllDocumentByCaseId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<DocumentListResDTO>> getAllDocumentByCaseId(
      @RequestParam(name = "caseId") Long caseId);

  /**
   * 通过案件ID查询协助调解员
   * 
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/getMediatorHelpPersonByCaseId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediatorHelpPersonResDTO>> getMediatorHelpPersonByCaseId(
      @RequestParam(name = "caseId") Long caseId);
}
