package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.CaseAcceptReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseAllotMediateOrgReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseOrgToAreaReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseRejectCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseSubmitBackReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseTransferReqDTO;
import com.beiming.odr.referee.dto.requestdto.EndAppealFeedbackReqDTO;

/**
 * @Author: chenjt
 * @Description: 佛山案件流转操作
 * @Date: Created 2019-09-06 15:45
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/operation")
@RestController
public interface FoShanCaseApi {

  /**
   * 市/区/镇管理员 受理案件
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/acceptCase", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult acceptCase(@RequestBody CaseAcceptReqDTO dto);


  /**
   * 市/区/镇管理员 不受理案件
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/rejectCase", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult rejectCase(@RequestBody CaseRejectCaseReqDTO dto);

  /**
   * 转移调解区域
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/transferArea", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult transferArea(@RequestBody CaseTransferReqDTO dto);

  /**
   * 提交上级管理员
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/submitParentAdmin", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult submitParentAdmin(@RequestBody CaseTransferReqDTO dto);


  /**
   * 提交X级管理员
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/submitAdmin", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult submitAdmin(@RequestBody CaseOrgToAreaReqDTO dto);

  /**
   * 下派调解区域
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/sendChildArea", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult sendChildArea(@RequestBody CaseTransferReqDTO dto);

  /**
   * 分配调解机构
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/allotMediateOrg", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult allotMediateOrg(@RequestBody CaseAllotMediateOrgReqDTO dto);

  /**
   * 提交到总平台
   *
   * @author chenjt
   * @date 2019年9月6日
   *
   */
  @RequestMapping(value = "/submitPlatform", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult submitPlatform(@RequestBody CaseSubmitBackReqDTO dto);
  
  /**
   * 办结审核不通过，回退到处理中
   */
  @RequestMapping(value = "/returnCaseProcessing", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult returnCaseProcessing(@RequestParam(name = "caseId") Long caseId, 
      @RequestParam(name = "userId") Long userId, @RequestParam(name = "userName") String userName);
  
  /**
   * 办结反馈（办结成功、办结失败）
   */
  @RequestMapping(value = "/endAppealFeedback", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult endAppealFeedback(@RequestBody EndAppealFeedbackReqDTO req);
  
  /**
   * 通过申请人身份证或者社会信用代码获取案件id
   */
  @RequestMapping(value = "/getCaseIdsByApplicantCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<Long>> getCaseIdsByApplicantCode(@RequestParam(name = "applicantCode") String applicantCode);

}

