package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.CasePersonReqDTO;
import com.beiming.odr.referee.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.InviteMediatorHelpReqDTO;
import com.beiming.odr.referee.dto.requestdto.UserIdListReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 案件人员api
 *
 * @author xzy
 * @data 2018年9月25日
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/lawCasePersonnel")
@RestController
public interface LawCasePersonnelApi {

  /**
   * 通过案件id查询案件人员
   */
  @RequestMapping(value = "/getCaseProtocolPersonList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CaseProtocolPersonnelResDTO>> getCaseProtocolPersonList(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "caseId") Long caseId);

  /**
   * 通过案件id查询案件人员
   */
  @RequestMapping(value = "/getMediationCasePersonList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationCasePersonnelDTO>> getMediationCasePersonList(
      @RequestBody @Valid CasePersonReqDTO dto);

  /**
   * 判断当前用户是否有上传调解材料的权限
   *
   * @param userId 用户id
   * @param caseId 案件id
   */
  @RequestMapping(value = "/checkUpload", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult checkUpload(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL) @RequestParam(
          name = "userId") Long userId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL) @RequestParam(
          name = "caseId") Long caseId);

  /**
   * 判断当前用户是否有删除调解材料的权限
   */
  @RequestMapping(value = "/checkDel", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult checkDel(@RequestBody @Valid DelFileReqDTO delFileReqDTO);

  /**
   * 判断当前用户是否有下载调解材料的权限
   */
  @RequestMapping(value = "/checkDownload", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult checkDownload(@RequestBody @Valid AttachmentListReqDTO attachmentListReqDTO);

  /**
   * 删除案件人
   */
  @RequestMapping(value = "/deleteByCaseUserType", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult deleteByCaseUserType(@RequestBody @Valid UserIdListReqDTO reqDTO);

  /**
   * 邀请协助调解员
   *
   * @param reqDTO 邀请人员列表
   * @param operator 操作人
   */
  @RequestMapping(value = "/inviteMediatorHelp", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult inviteMediatorHelp(@RequestBody @Valid InviteMediatorHelpReqDTO reqDto);

  /**
   * 根据身份证查询登记过案件的人员
   */
  @RequestMapping(value = "/getPersonListByIdCard", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationCasePersonnelDTO>> getPersonListByIdCard(
      @Valid @NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "idCard") String idCard);

  @RequestMapping(value = "/getPersonList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CaseProtocolPersonnelResDTO>> getPersonList(@Valid @NotNull(
      message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
      name = "caseId") Long caseId);

}
