package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.referee.dto.responsedto.WorkbenchDocStatusResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * 调解附加信息API
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationAdditionalInfo")
@RestController
public interface MediationAdditionalInfoApi {

  /**
   * 获取案件文书材料
   * 
   * @param lawCaseId
   * @return
   */
  @RequestMapping(value = "/getMediationDocuments", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE, params = {"lawCaseId"})
  DubboResult<ArrayList<CaseMaterialResDTO>> getMediationDocuments(
      @RequestParam(name = "lawCaseId") Long lawCaseId);

  /**
   * 获取文书材料
   * 
   * @param objectId
   * @param objectType
   * @return
   */
  @RequestMapping(value = "/getMediationDocuments", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE, params = {"objectId", "objectType"})
  DubboResult<ArrayList<CaseMaterialResDTO>> getMediationDocuments(
      @RequestParam(name = "objectId") Long objectId,
      @RequestParam(name = "objectType") String objectType);

  /**
   * 
   * @param lawCaseId
   * @param userId
   * @param workbenchModel true：用户签名后不显示文书|false：必须显示已发送文书
   * @return
   */
  @RequestMapping(value = "/getMediationWorkbench", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<WorkbenchDocStatusResDTO>> getMediationWorkbench(
      @RequestParam(name = "lawCaseId") Long lawCaseId, @RequestParam(name = "userId") Long userId,
      @RequestParam(name = "workbenchModel") Boolean workbenchModel);

}
