package com.beiming.odr.referee.api;

import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationDissentGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSendResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * 异议书API
 * 
 * @author DJQ 2018年6月26日
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationDocDissent")
@RestController
public interface MediationDocDissentApi {

  /**
   * 发送异议书
   * 
   * @return
   */
  @RequestMapping(value = "/sendMediationDissent", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationDissentSendResDTO> sendMediationDissent(
      @RequestBody @Valid MediationDissentSendReqDTO reqDTO);

  /**
   * 获取异议书
   * 
   * @return
   */
  @RequestMapping(value = "/getMediationDissent", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationDissentGetResDTO> getMediationDissent(
      @RequestBody @Valid MediationDissentGetReqDTO reqDTO);

  /**
   * 保存异议书
   * 
   * @return
   */
  @RequestMapping(value = "/saveMediationDissent", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationDissentSaveResDTO> saveMediationDissent(
      @RequestBody @Valid MediationDissentSaveReqDTO reqDTO);

}
