package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.CountDTO;
import com.beiming.odr.referee.dto.requestdto.EndCaseAuditConditionReqDTO;
import com.beiming.odr.referee.dto.requestdto.ListPetitionAgentMediationReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationListReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationProgressReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationStatusCountReqDTO;
import com.beiming.odr.referee.dto.requestdto.PetitionAgentCountReqDTO;
import com.beiming.odr.referee.dto.responsedto.EndCaseAuditConditionResDTO;
import com.beiming.odr.referee.dto.responsedto.ListPetitionAgentMediationResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationCasePersResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationCountResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationListResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationProgressResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationStatusCountResDTO;
import com.beiming.odr.referee.dto.responsedto.PetitionAgentCountResDTO;

/**
 * 调解信息API
 *
 * @author DJQ 2018年6月27日
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationInfo")
@RestController
public interface MediationInfoApi {

  /**
   * 调解进度查看接口
   *
   * @param reqDTO *
   */
  @RequestMapping(value = "/getMediationProgress", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationProgressResDTO>> getMediationProgress(
      @RequestBody @Valid MediationProgressReqDTO reqDTO);

  /**
   * 单个案件查询接口
   */
  @RequestMapping(value = "/getMediationInfo", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationInfoResDTO> getMediationInfo(@RequestBody @Valid MediationInfoReqDTO reqDTO);

  /**
   * 根据lawCaseIds返回调解信息内的参与人信息
   */
  @RequestMapping(value = "/getMediationCasePers", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationCasePersResDTO>> getMediationCasePers(
      @RequestParam(name = "lawCaseIds") ArrayList<Long> lawCaseIds);
  
  /**
   * 案件详情信息（草稿）
   */
  @RequestMapping(value = "/getMediationInfoDraft", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationInfoResDTO> getMediationInfoDraft(@RequestBody MediationInfoReqDTO reqDTO);

  /**
   * 案件列表查询接口 （如果是去掉关联的调解，被申请人不可以看详情）<br>
   */
  @RequestMapping(value = "/listMediationInfo", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<MediationListResDTO>> listMediationInfo(
      @RequestBody @Valid MediationListReqDTO reqDTO);

  /**
   * 案件列表查询接口(草稿)
   *
   * @author djq
   * @date 2019年4月25日
   */
  @RequestMapping(value = "/listMediationInfoDraft", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<MediationListResDTO>> listMediationInfoDraft(
      @RequestBody @Valid MediationListReqDTO reqDTO);

  /**
   * 根据useridList返回调解数量<br> 调解员
   */
  @RequestMapping(value = "/countMediatorLawCaseNum", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationCountResDTO> countMediatorLawCaseNum(@RequestParam(
      name = "userIds") ArrayList<Long> userIds);

  /**
   * 根据userid返回全部,等待调解，正在调解的数量(list)<br>
   */
  @RequestMapping(value = "/countMediatorLawCaseStatus", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationStatusCountResDTO>> countMediatorLawCaseStatus(
      @RequestBody @Valid MediationStatusCountReqDTO reqDTO);

  /**
   * 统计用户案件信息 包括用户是创建人，申请人，代理人
   *
   * @param userId 用户id
   * @return 案件数量在data中
   */
  @RequestMapping(value = "/countUserCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Long> countUserCase(@RequestParam(
      name = "userId") Long userId);

  /**
   * 信访代理人代理案件列表
   */
  @RequestMapping(value = "/listPetitionAgentMediation", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<ListPetitionAgentMediationResDTO>> listPetitionAgentMediation(
      @RequestBody @Valid ListPetitionAgentMediationReqDTO reqDTO);

  /**
   * 信访代理人案件统计
   *
   * @return 返回统计数据
   */
  @RequestMapping(value = "/petitionAgentCaseCount", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PetitionAgentCountResDTO> petitionAgentCaseCount(
      @RequestBody @Valid PetitionAgentCountReqDTO reqDTO);

  /**
   * 根据调解员ID统计
   */
  @RequestMapping(value = "/countByMediatorId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CountDTO>> countByMediatorId();

  /**
   * 根据机构ID统计
   */
  @RequestMapping(value = "/countByOrgId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CountDTO>> countByOrgId();

  /**
   *
   */
  @RequestMapping(value = "/countLawCaseNumByUser", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CountDTO>> countLawCaseNumByUser(
      @RequestParam(name = "userIds") ArrayList<Long> userIds);

  
  /**
   *  结案审核条件查询
   */
  @RequestMapping(value = "/endCaseAuditCondition", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<EndCaseAuditConditionResDTO>> endCaseAuditCondition(@RequestBody @Valid EndCaseAuditConditionReqDTO req);
}
