package com.beiming.odr.referee.api;

import com.beiming.odr.referee.dto.responsedto.RoleFileDTO;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * 文件上传材料类型权限控制
 */
@RequestMapping(RefereeApiConst.URL_PREFIX + "/roleFile")
@RestController
public interface RoleFileApi {

  @RequestMapping(value = "/getRoleFile", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  List<RoleFileDTO> getRoleFile(@RequestParam(name = "roleType") @Valid String roleType);

  /**
   * 获取上传材料类型权限 add by chenjt 2018-11-15
   */
  @RequestMapping(value = "/getRoleFileInfoByTypes", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  List<RoleFileDTO> getRoleFileInfoByTypes(
      @RequestParam(name = "roleTypes") List<String> roleTypes);
}
