package com.beiming.odr.referee.api;

import java.util.ArrayList;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.DisputeStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.DisputeSubjectStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediateStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.OrgCaseStatisticsReqDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeTypeResDTO;
import com.beiming.odr.referee.dto.responsedto.DisputesSubjectStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.MediateStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationAssistStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.StatisticsOrgAreaResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * @Author: chenjt
 * @Description: 报表统计
 * @Date: Created 2018-07-04 20:02
 */
@RequestMapping(RefereeApiConst.URL_PREFIX + "/statementStatistics")
@RestController
public interface StatementStatisticsApi {

  /**
   * 纠纷报表统计(一个方法返回所有数据, 保留 2018-10-22后使用拆开后的)
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/disputeStatisticsData", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<DisputeStatisticsResDTO> disputeStatisticsData(
      @RequestBody DisputeStatisticsReqDTO reqDTO);

  /**
   * 定时任务,取得每天的分类调解案件数量统计, 保存入库
   * 
   * @param startDate
   * @param endtDate
   * @return
   */
  @RequestMapping(value = "/everyDayTaskStatisticsList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult everyDayTaskStatisticsList(@RequestParam(name = "startDate") String startDate,
      @RequestParam(name = "endDate") String endDate);

  // -----华丽的分割线-----------------下面接口由 disputeStatisticsData 拆开成5个接口


  /**
   * 统计纠纷总量.调解总量,及总数量 XXX纠纷数量统计/业务类型调解统计
   * 
   * @param reqDTO
   * @return
   */
  // DubboResult<DisputeStatisticsResDTO> disputeCountAndLawCaseCount(DisputeStatisticsReqDTO
  // reqDTO);

  /**
   * 平台地图 统计纠纷总量.调解总量,及总数量,调解案件成功数量,调解案件失败数量,诉讼案件数量,司法确认案件数量
   * 
   * @param reqDTO
   * @return
   */
  // DubboResult<PlatMapStatisticsResDTO> platMapStatistics(DisputePlatMapStatisticsReqDTO reqDTO);

  /**
   * XXX纠纷数量统计/业务类型调解统计 XXX业务类型咨询统计
   * 
   * @param reqDTO
   * @return
   */
  // DubboResult<DisputeStatisticsResDTO> disputeListAndLawCaseList(DisputeStatisticsReqDTO reqDTO);

  /**
   * XXX各区域纠纷类型统计
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/disputeTypeAreaStatisticsList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<DisputeStatisticsResDTO> disputeTypeAreaStatisticsList(
      @RequestBody DisputeStatisticsReqDTO reqDTO);

  /**
   * XXX各区域调解案件数量统计
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/orgAreaStatisticsList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<DisputeStatisticsResDTO> orgAreaStatisticsList(
      @RequestBody DisputeStatisticsReqDTO reqDTO);

  /**
   * 机构的纠纷调解数量(2018-11-07)
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/queryOrgCaseCount", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<StatisticsOrgAreaResDTO>> queryOrgCaseCount(
      @RequestBody OrgCaseStatisticsReqDTO reqDTO);

  /**
   * 纠纷类型(需要按最近一个月使用次数排序)(2018-11-07)
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/queryDisputeTypeCount", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<DisputeTypeResDTO>> queryDisputeTypeCount(
      @RequestBody DisputeSubjectStatisticsReqDTO reqDTO);

  /**
   * 纠纷专题统计-各区域纠纷类型统计
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/disputeTypeAreaStatisticsList2", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<DisputeStatisticsResDTO> disputeTypeAreaStatisticsList2(
      @RequestBody DisputeStatisticsReqDTO reqDTO);

  /**
   * 纠纷专题统计-调解案件走势分析-街道调解案件数量分析-调解状态分析-申请人角色分析-调解结果分析
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/disputesSubjectStatistics", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<DisputesSubjectStatisticsResDTO> disputesSubjectStatistics(
      @RequestBody DisputeStatisticsReqDTO reqDTO);


  /**
   * 调解员案件统计 调解员指标权重统计使用(2018-11-26)
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/caseStatisticsByMediator", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediateStatisticsResDTO>> caseStatisticsByMediator(
      @RequestBody MediateStatisticsReqDTO reqDTO);

  /**
   * 调解机构案件统计 调解机构指标权重统计使用(2018-11-26)
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/caseStatisticsByOrgId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediateStatisticsResDTO>> caseStatisticsByOrgId(
      @RequestBody MediateStatisticsReqDTO reqDTO);

  /**
   * 调解业绩协助调解员统计
   * 
   * @return
   */
  @RequestMapping(value = "/caseAssistStatisticsByMediatorHelpId", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MediationAssistStatisticsResDTO>> caseAssistStatisticsByMediatorHelpId(
      @RequestBody MediateStatisticsReqDTO reqDTO);
}
