package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.responsedto.MediationRoomStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.StatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.VideoAndDocumentStatisticsResDTO;
import java.util.ArrayList;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * @Author: chenjt
 * @Description: 统计
 * @Date: Created 2019-01-28 20:02
 */
@RequestMapping(RefereeApiConst.URL_PREFIX + "/statistics")
@RestController
public interface StatisticsApi {

  /**
   * 待进入视频,待确认文书统计
   * 
   * @param userId
   * @return
   */
  @RequestMapping(value = "/videoAndDocumentStatistics", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<VideoAndDocumentStatisticsResDTO> videoAndDocumentStatistics(
      @RequestParam(name = "userId") Long userId);


  /**
   * PC首页.调解室统计
   * 
   * @param userId
   * @return
   */
  @RequestMapping(value = "/mediationRoomStatistics", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationRoomStatisticsResDTO> mediationRoomStatistics(
      @RequestParam(name = "userId") Long userId);

  /**
   * 用户会议视频统计
   * 
   * @param userId
   * @return
   */
  @RequestMapping(value = "/userMediationMeetingCount", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Integer> userMediationMeetingCount(@RequestParam(name = "userId") Long userId);


  /**
   * PC首页.调解会议视频统计
   * 
   * @param userId
   * @return
   */
  @RequestMapping(value = "/mediationMeetingStatistics", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationRoomStatisticsResDTO> mediationMeetingStatistics(
      @RequestParam(name = "userId") Long userId);

  /**
   * 环资2期案件统计
   * 
   * @return
   */
  @RequestMapping(value = "/statisticsCase", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<StatisticsResDTO>> statisticsCase();

}
