package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * 新建视频会议请求参数
 * 
 * @author qsh
 * @date 2019年2月20日
 */
@Data
public class AddMediationMeetingRoomReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 调解会议名称
   */
  private String mediationMeetingRoomName;

  /**
   * 当事人信息列表
   */
  private List<MediationMeetingUserInfoReqDTO> litigantList;

  /**
   * 调解员
   */
  private MediationMeetingUserInfoReqDTO mediator;
  /**
   * 会议预订时间
   */
  private Date orderTime;

  /**
   * 是否需要身份验证
   */
  private Integer authFlag;

  /**
   * 是否需要身电话提醒
   */
  private Integer callFlag;

  /**
   * 创建者id
   */
  private Long creatorId;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;
  
  /**
   * 调解室会议id
   */
  private Long parentId;

}
