package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 分配调解机构
 * 
 * @author chenjt
 * @data 2019年9月8日
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AllotMediateOrgReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  @NotNull(message = "案件id不能为空")
  private Long caseId;
  @NotBlank(message = "转出区域代码不能为空")
  private String fromAreaCode;
  @NotBlank(message = "转入区域代码不能为空")
  private String orgAreaCode;
  @NotNull(message = "机构id不能为空")
  private Long orgId;
  @NotBlank(message = "机构名称不能为空")
  private String orgName;
  @NotNull(message = "用户id不能为空")
  private Long userId;
  @NotBlank(message = "用户名不能为空")
  private String userName;

}
