package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt on 2019/9/8.
 *
 * 案件分配机构
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CaseAllotMediateOrgReqDTO implements Serializable {

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long caseId;

  //分配机构的areaCode
  @NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private String orgAreaCode;

  //分配机构
  @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private Long orgId;

  //分配机构
  @NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private String orgName;

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private Long userId;

  @NotBlank(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private String userName;

}
