package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 案件人员文书确认地址请求参数
 * 
 * @author qsh
 * @date 2019年1月23日
 */
@Data
public class DocAddressReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 人员id
   */
  @NotNull(message = "人员id不能为空")
  private Long personnelId;
  @NotNull(message = "案件id不能为空")
  private Long caseId;
  @NotNull(message = "文件id不能为空")
  private String fileId;
  @NotNull(message = "文件名不能为空")
  private String fileName;
  @NotNull(message = "sign不能为空")
  private String sign;
  private String categoryMiddle;
  private String objectType; // 类型
  private String categoryBig;
  private Long userId;
  private String userName;

}
