package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import com.beiming.framework.page.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询案件列表的请求参数(同步机构)
 * 
 * @ClassName: MediationListOrgsReqDTO.java
 *
 * @version: v1.0.0
 * @author: djq
 * @date: 2019年4月26日
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MediationListOrgsReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private Long userId; // 用户ID

  private Long orgId; // 用户机构ID

  private String caseNo; // 案件编号

  private List<Long> recordOrgId; // 机构类型

  private String caseStatus; // 案件状态

}
