package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.message.BaseMessageDto;
import com.beiming.odr.referee.constant.TopicConst.DynamicRemindSubjectType;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by zli on 2018/7/6.
 *
 * 个人中心的红点
 */
@Data
@NoArgsConstructor
public class PersonRedRemindRequestDTO extends BaseMessageDto implements Serializable {

  private static final long serialVersionUID = 8604979634950742757L;
  
  /**
   * 业务主键，防止重复消费消息
   */
  private String bizKey;
  
  /**
   * 操作时间
   */
  private Date operationTime;

  /**
   * 进度
   */
  //private String status;

  /**
   * 用户Id
   */
  private String userId;

  /**
   * 生产者调用时无需设值。在producer中写死
   *
   * @see DynamicRemindSubjectType
   */
  private String subjectType;


  public PersonRedRemindRequestDTO(Date operationTime, String userId) {
    this.operationTime = operationTime;
    this.userId = userId;
  }
}
