package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 案件信息
 * 
 * @author qsh
 *
 * @2019年6月13日
 */
@Data
public class SaveMediationForOpenReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 法院
   */
  @NotNull(message = "法院不能为空")
  private Integer courtCode;
  /**
   * 调解信息对象
   */
  @NotNull(message = "调解信息对象不能为空")
  private ThirtMediationReqDTO mediation;
  /**
   * 调当事人信息
   */
  private List<ThirdPartysReqDTO> partys;
  /**
   * 调解员信息
   */

  private Integer mediatorId;
  /**
   * 调解组织信息id
   */

  private Integer organizationId;
  /**
   * 调解笔录
   */
  private List<ThirtRecordsReqDTO> records;
  /**
   * 调解协议文件名称
   */
  private String mediationStatementName;
  /**
   * 调解协议文件地址
   */
  private String mediationStatementUrl;
  /**
   * 案件id
   */
  private Long caseId;

}
