package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 推送案件
 * 
 * @author qsh
 *
 * @2019年6月13日
 */
@Data
public class SaveMediatorReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 法院
   */
  @NotNull(message = "法院不能为空")
  private Integer courtCode;
  /**
   * 姓名
   */
  private String name;
  /**
   * 手机号码
   */
  @NotNull(message = "手机号码不能为空")
  private int telephone;
  /**
   * 性别
   */
  private String sex;
  /**
   * 职业
   */
  private String job;
  /**
   * 调解员身份
   */
  private String identity;
  /**
   * 文化程度
   */
  private String grade;
  /**
   * 出生日期
   */
  private String birthday;
  /**
   * 身份证号码
   */
  @NotNull(message = "法身份证号码不能为空")
  private String idcardNo;
  /**
   * 地址
   */
  private String address;
  /**
   * 个人简介
   */
  private String profile;
  /**
   * 擅长领域
   */
  private String majorScopes;
  /**
   * 调解员头像文件名
   */
  private String avatarName;
  /**
   * 调解员头像
   */
  private String avatarUrl;
  /**
   * 调解员所属组织 id
   */
  private String orgId;
  /**
   * 调解员 id
   */
  private String mediatorId;
  /**
   * 平台调解员 id
   */
  private Long platformMediatorId;

}
