package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.DocumentTypeEnum;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description: 保存协议书请求参数实体
 * @Author: caiwei
 * @Date: Created 2018-07-01
 */
@Data
public class SaveProtocolBookReqDTO implements Serializable {

  private static final long serialVersionUID = -779140827827576519L;

  // 协议书id
  private Long protocolId;
  
  // MeetingId
  private Long meetingId;

  // 案件id
  private Long caseId;

  // 文书类型
  private DocumentTypeEnum documentType;

  // 案件号
  private String caseNo;

  // 协议相关人员
  private List<CaseProtocolPersonnelReqDTO> personnelList;

  // 争议事项或调解过程
  private String content;

  // 达成协议或者无争议事实
  private String extendJson;

  // 创建者
  private String createUser;

  // 更新者
  private String updateUser;
  
  // 备注
  private String remark;

  // 协助调解员
  List<MediatorHelpPersonReqDTO> helpList;
}
