package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SignatureBizInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -1057959836990248318L;

  /**
   * 文书ID
   */
  private Long docId;
  /**
   * 需要置为失效的文书ID（进度内文书所对应的旧进度处理）
   */
  private Long docIdDisable; 
  /**
   * 文书名称
   */
  private String docName;
  /**
   * 文书类型
   */
  private String docType;
  /**
   * 会议ID
   */
  private Long meetId;
  /**
   * 业务主体ID
   */
  private Long bizId;
  /**
   * 业务主体类型
   */
  private String bizType;
  /**
   * 用户ID
   */
  private Long userId;
  /**
   * 用户名称
   */
  private String userName;
  /**
   * 用户类型
   */
  private String caseUserType;
  /**
   * 确认人Ids
   */
  private String confirmIds;
  
  /**
   * 是否取消后续动作
   */
  private Boolean cancel = false;
  /**
   * 是否角色用户最后一个
   */
  private Boolean isTypeLast = false;
  /**
   * 是否全用户最后一个
   */
  private Boolean isAllLast = false;

  public SignatureBizInfoReqDTO(Long docId, String docName, String docType, Long meetId, Long bizId,
      String bizType, Long userId, String userName, String caseUserType) {
    super();
    this.docId = docId;
    this.docName = docName;
    this.docType = docType;
    this.meetId = meetId;
    this.bizId = bizId;
    this.bizType = bizType;
    this.userId = userId;
    this.userName = userName;
    this.caseUserType = caseUserType;
  }

}
