package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 签名确认结果信息参数
 * 
 * @author chenjt 2019-01-285
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SignatureConfirmInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -8433803681683752785L;

  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId; // 用户ID
  @NotNull(message = RefereeValidateMessage.PARAMETER_DOCUMENT_ID_NULL)
  private List<Long> documentIds; // 文书ID


}
