package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 案件调解信息
 * 
 * @author qsh
 *
 * @2019年6月13日
 */
@Data
public class ThirtMediationReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 案件id
   */
  @NotNull(message = "案件id不能为空")
  private String mediationId;
  /**
   * 案号
   */
  @NotNull(message = "案号不能为空")
  private String caseNo;
  /**
   * 调解状态4成功5失败6终止
   */
  @NotNull(message = "调解状态不能为空")
  private Integer state;
  /**
   * 案件类型
   */
  @NotNull(message = "案件类型不能为空")
  private String caseType;
  /**
   * 纠纷概述
   */
  private String dispute;
  /**
   * 调解类型0 互联网调解 1 诉前调解2 诉中调解
   */
  private Integer type;
  /**
   * 案调解申请时间
   */
  @NotNull(message = "调解申请时间不能为空")
  private Date applyDate;
  /**
   * 调解结束时间
   */
  @NotNull(message = "调解结束时间不能为空")
  private Date endDate;
}
