package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * Created by zli on 2019/1/28.
 *
 * 按照案件里的人员类型来删除
 */
@Setter
@Getter
@NoArgsConstructor
public class UserIdListReqDTO extends CaseIdReqDTO implements Serializable {

  private static final long serialVersionUID = 6871989281828819536L;
  /**
   * 用户ID
   */
  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL)
  private List<Long> userIdList;

  /**
   * 案件用户类型
   *
   * @see com.beiming.odr.referee.enums.CaseUserTypeEnum
   */
  private String caseUserType;

  public UserIdListReqDTO(Long caseId, List<Long> userIdList, String caseUserType) {
    super(caseId);
    this.userIdList = userIdList;
    this.caseUserType = caseUserType;
  }

  @Override
  public String toString() {
    return "UserIdListReqDTO{"
        + "userIdList=" + userIdList
        + ", caseUserType='" + caseUserType + '\''
        + "} " + super.toString();
  }
}
