package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;

/**
 * @Description: 协议相关人返回实体
 * @Author: caiwei
 * @Date: Created 2018-06-30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CaseProtocolPersonnelResDTO implements Serializable {

  private static final long serialVersionUID = -4866238168967161027L;
  // 人员id
  private Long personnelId;

  // 文书id
  private Long documentId;

  // 案件用户类型
  private String caseUserType;

  // 用户ID
  private Long userId;

  // 用户类型
  private String userType;

  // 名称
  private String userName;

  // 性别
  private String sex;

  // 电话
  private String phone;

  // 身份证号
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  private String address;

  // 信用代码
  private String creditCode;

  // 法人代表
  private String corporation;

  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;
  
  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人联系电话
   */
  private String agentPhone;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;
  

  // 排序
  private Integer userOrder;
  /**
   * 送达地址确认书
   */
  private String docAddress;
  /**
   * 材料id
   */
  private Long lawAttachmentId;

  /**
   * 其它联系电话
   */
  private String contactPhone;

  /**
   * 代理人固定电话
   */
  private String agentTelephone;

  /**
   * 当事人固定电话
   */
  private String telephone;

  public CaseProtocolPersonnelResDTO(MediationCasePersonnelDTO personnel) {
    this.documentId = personnel.getDocumentId();
    this.caseUserType = personnel.getCaseUserType();
    this.userId = personnel.getUserId();
    this.userType = personnel.getUserType();
    this.userName = personnel.getName();
    this.sex = personnel.getSex();
    this.phone = personnel.getPhone();
    this.idCard = personnel.getIdCard();
    this.provCode = personnel.getProvCode();
    this.cityCode = personnel.getCityCode();
    this.areaCode = personnel.getAreaCode();
    this.streetCode = personnel.getStreetCode();
    this.provName = personnel.getProvName();
    this.cityName = personnel.getCityName();
    this.areaName = personnel.getAreaName();
    this.streetName = personnel.getStreetName();
    this.address = personnel.getAddress();
    this.creditCode = personnel.getCreditCode();
    this.corporation = personnel.getCorporation();
    this.agentId = personnel.getAgentId();
    this.agentName = personnel.getAgentName();
    this.agentSex = personnel.getAgentSex();
    this.agentPhone = personnel.getAgentPhone();
    this.agentIdCard = personnel.getAgentIdCard();
    this.userOrder = personnel.getUserOrder();
    this.docAddress = personnel.getDocAddress();
    this.lawAttachmentId = personnel.getLawAttachmentId();
    this.agentTelephone = personnel.getAgentTelephone();
    this.contactPhone = personnel.getContactPhone();
    this.telephone = personnel.getTelephone();
  }

}
