package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 当事人列表
 * 
 * @author qsh
 * @date 2019年5月6日
 */
@Data
@NoArgsConstructor
public class LitigantMeetingListResDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * id
   */
  private Long id;
  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 调解室/视频会议名字
   */
  private String name;

  /**
   * 调解/视频会议状态
   */
  private String mediationStatus;

  /**
   * 会议预订时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date orderTime;
  
  /**
   * 会议结束时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date endTime;

  /**
   * 调解室/会议视频房间id
   */
  private String roomId;

  /**
   * 会议类型
   */
  private String meetingType;
  /**
   * 预约类型
   */
  private String orderType;


  /**
   * 调解会议用户类型
   */
  private String meetingUserType;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户类型
   */
  private String userType;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 用户性别
   */
  private String userSex;

  /**
   * 手机号
   */
  private String mobilePhone;
  private Long orgId;
  private String orgName;
}
