package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 调解室用户信息返回实体类
 * @Author: caiwei
 * @Date: 2019/1/16
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationRoomUserInfoResDTO implements Serializable {

  private static final long serialVersionUID = -6981212646954319507L;

  /**
   * 人员id
   */
  private Long personId;

  /**
   * 调解会议用户类型
   */
  private String meetingUserType;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户类型
   */
  private String userType;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 用户性别
   */
  private String userSex;

  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 认证状态
   */
  private Integer authStatus;

  /**
   * 用户排序
   */
  private Integer userOrder;

  /**
   * 代理人当事人id
   */
  private Long agentParentId;
}