package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 环资列表返回
 * 
 * @author qsh
 * @date 2019年4月25日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ScavengerMeetingListResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;
  /**
   * 视频会议名字
   */
  private String name;
  /**
   * 会议预订时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date orderTime;
  /**
   * 会议开始时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date startTime;
  /**
   * 会议结束时间
   */
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date endTime;
  /**
   * 会议类型
   */
  private String meetingType;
  /**
   * 机构id
   */
  private Long orgId;
  /**
   * 机构名称
   */
  private String orgName;
  /**
   * 视频会议状态
   */
  private String mediationStatus;
  
  private String roomId;
  
  private Long caseId;
  
  private Long creatorId;

}
