package com.beiming.odr.referee.enums;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * @Description: 案件状态枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseStatusEnum {
  REFUSE_ACCEPTANCE("不受理"),
  APPLY_SUBMIT("案件申请提交"),

  REJECT_DIRECT("直接拒绝退到总平台"),
  BACK_SUBMIT("提交退回到总平台"),
  BACK_PUBLIC_LAW_CENTER("退回公法中心"),
  BACK_PLATFORM("退回总平台"),

  WAIT_ALLOCATED_TO_MEDIATION_AGENCY("已分配给调解机构"),
  WAIT_TRANSFER_TO_MEDIATION_AGENCY("转移调解机构"),

  WAIT_TRANSFER_ADMIN_ACCEPT("区域管理员受理诉求"),
  WAIT_TRANSFER_ADMIN_REFUSE_ACCEPTANCE("区域管理员不受理诉求"), //流转过程中的不受理, 若是总平台下来的直接不受理,使用 REJECT_DIRECT
  WAIT_TRANSFER_ORG_SUBMIT_ADMIN("调解机构提交本级管理员"), //调解机构提交X级管理员
  WAIT_TRANSFER_ADMIN_SUBMIT_PARENT("区域管理员提交上级管理员"),
  WAIT_TRANSFER_ADMIN_SUBMIT_CHILD("区域管理员下派调解区域"),
  WAIT_TRANSFER_ADMIN_TRANSFER_AREA("区域管理员转移调解区域"),
  WAIT_TRANSFER_ADMIN_ALLOT_ORG("区域管理员分配调解机构"),

  WAIT_ASSIGNED_TO_MEDIATOR("已分配给调解员"),
  WAIT_MEDIATOR_REALLOCATE("纠纷等待分配"),
  WAIT_APPLY_REALLOCATE("申请重新分配"),
  //  WAIT_UNABLE_MEDIATION("无法调解"),
  WAIT_MEDIATOR_CHECK_CASE_DATA("调解员查看案件资料"),
  WAIT_CASE_ACCEPTANCE("案件受理"),
  WAIT_MEDIATION_DOC_ADDRESS_BOOK("送达地址确认书"),
  START_ORDER_MEDIATION_TIME("已预约调解时间"),
  START_ORDER_VIDEO_RESEARCH("已经预约视频调查"),
  START_INVITE_VIDEO_RESEARCH("调解员邀请观摩人"),
  START_VIDEO_MEDIATION_START("视频调解或调查开始"),
  START_VIDEO_MEDIATION_END("视频调解或调查结束"),
  START_ORDER_UNDER_LINE_MEETING_TIME("预约线下会议时间"),
  
  // ### 文书类状态 START
  START_DOCUMENT_MEDIATOR_BATCH_SEND("调解员发送多份文书"), // 调解员发送了#content#
  START_DOCUMENT_CLIENT_BATCH_CONFIRM("当事人同意多份文书"), // #userType##name#同意了#content#
  START_DOCUMENT_ASSISTANT_BATCH_CONFIRM("协助调解员同意多份文书"), // 协助调解员#name#同意了#content#
  // 调解协议
  START_MEDIATION_PROTOCOL_MEDIATOR_SEND("调解员发送调解协议书"),
  START_MEDIATION_PROTOCOL_ONE_REFUSE("一方拒绝了调解协议"),
  START_MEDIATION_PROTOCOL_ONE_CONFIRM("一方确认了调解协议"),
  START_MEDIATION_PROTOCOL_CONFIRM_FAIL("调解协议确认失败"),
  START_MEDIATION_PROTOCOL_CONFIRM_SUCCESS("调解协议确认成功"),
  START_MEDIATION_PROTOCOL_ASSISTANT_ONE_REFUSE("协助调解员拒绝了调解协议"),
  START_MEDIATION_PROTOCOL_ASSISTANT_ONE_CONFIRM("协助调解员确认了调解协议"),
  // 无争议事实
  START_UNDISPUTED_FACTS_MEDIATOR_SEND("调解员发送了无争议事实"),
  START_UNDISPUTED_FACTS_CONFIRM("确认了无争议事实"),
  START_UNDISPUTED_FACTS_REFUSE("拒绝了无争议事实"),
  START_UNDISPUTED_FACTS_CONFIRM_SUCCESS("无争议事实确认成功"),
  START_UNDISPUTED_FACTS_CONFIRM_FAIL("无争议事实确认失败"),
  START_UNDISPUTED_FACTS_ASSISTANT_CONFIRM("协助调解员确认了无争议事实"),
  START_UNDISPUTED_FACTS_ASSISTANT_REFUSE("协助调解员拒绝了无争议事实"), 
  // 无异议调解方案
  START_NO_OBJECTION_MEDIATION_SCHEME_SEND("发送了无异议调解方案"),
  START_PROMISE_ONE_CONFIRM("一方确认承诺书"),
  START_PROMISE_ONE_REFUSE("一方拒绝承诺书"),
  START_MEDIATION_SCHEME_ONE_CONFIRM("一方同意了调解方案"),
  START_MEDIATION_SCHEME_ONE_REFUSE("一方拒绝了调解方案并且提出了异议书"),
  START_MEDIATION_SCHEME_CONFIRM_SUCCESS("无异议调解方案确认成功"),
  START_MEDIATION_SCHEME_CONFIRM_FAIL("无异议调解方案确认失败"),
  START_PROMISE_ASSISTANT_ONE_CONFIRM("协助调解员确认承诺书"),
  START_PROMISE_ASSISTANT_ONE_REFUSE("协助调解员拒绝承诺书"),
  START_MEDIATION_SCHEME_ASSISTANT_ONE_CONFIRM("协助调解员同意了调解方案"),
  START_MEDIATION_SCHEME_ASSISTANT_ONE_REFUSE("协助调解员拒绝了调解方案并且提出了异议书"),
  // 笔录
  START_MEDIATOR_SEND_RESEARCH_RECORD("调解员发送调查笔录"),
  START_MEDIATION_RECORD_REFUSE("当事人拒绝了调解（调查）笔录"),
  START_MEDIATION_RECORD_AGREE("当事人同意了调解（调查）笔录"),
  START_MEDIATION_RECORD_ASSISTANT_REFUSE("协助调解员同意了调解（调查）笔录"),
  START_MEDIATION_RECORD_ASSISTANT_AGREE("协助调解员同意了调解（调查）笔录"),
  // 调解申请书
  START_MEDIATION_APPLY_BOOK_SEND("调解员发送调解申请书"),
  START_MEDIATION_APPLY_BOOK_REFUSE("拒绝了调解申请书"),
  START_MEDIATION_APPLY_BOOK_CONFIRM("确认了调解申请书"),
  START_MEDIATION_APPLY_BOOK_ASSISTANT_REFUSE("协助调解员拒绝了调解申请书"),
  START_MEDIATION_APPLY_BOOK_ASSISTANT_CONFIRM("协助调解员确认了调解申请书"),
  // ### 文书类状态 END
  
  RETRACT_CANCEL_CASE("撤回调解案件"),
  RETRACT_CANCEL_CASE_MEDIATOR("调解员撤回调解案件"),
  FAIL_MEDIATION("调解失败"),
  FAIL_MEDIATION_APPLY("调解失败申请"),
  FAIL_EXCEED_MEDIATION_TERM("超过调解期限"),
  FAIL_SUIT_APPLY("已申请诉讼"),
  SUCCESS_MEDIATION("调解成功"),
  SUCCESS_MEDIATION_APPLY("调解成功申请"),
  //其他情形结案
  END_MEDIATION_OTHER("其他情形"),

  // 环资案件使用
  SUCCESS_CASE_DEAL("案件处理完毕"),
  START_CASE_UNCLOSED("案件未结案"),
  
  // 司法确认申请书
  SUCCESS_JUDICIAL_CONFIRM_APPLY_SEND("调解员发送了申请司法确认申请书"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_CONFIRM("确认了申请司法确认申请书"),
  SUCCESS_JUDICIAL_CONFIRM_REFUSE_APPLY("拒绝了申请司法确认申请书"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_SUCCESS("申请司法确认申请确认成功"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY_FAIL("申请司法确认申请确认失败"),
  SUCCESS_JUDICIAL_CONFIRM_APPLY("已申请司法确认"),
  
  START_MEDIATION_LOOK_CASE("调解员查看纠纷详情"), // 调解员查看案件资料
  START_MEDIATION_DEFERRED("调解员延长调解期限"),
  START_MEDIATION_UPCOMING_DUE_NOTICE("调解期限倒计时通知"),
  
  START_INVITE_MEDIATOR_HELP("邀请协助调解员"),
  START_CANCEL_MEDIATOR_HELP("取消邀请协助调解员"),
  START_INVITE_MEDIATOR_HELP_AGAIN("重新邀请协助调解员"),
  START_INVITE_MEDIATOR_HELP_TEMPORARY("邀请临时调解员"),
  START_CASE_FINISH_AUDIT_NOT_PASS("案件办结审核不通过"),

  START_JIANGSU_RESULT("获取“苏解纷”办理结果")
  
  ;

  private String name;

  CaseStatusEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }
  
  /**
   * 根据状态前缀获取进度枚举值
   * 
   * @param caseStatusEnum
   * @return
   */
  public static CaseProgressEnum getCaseProgressEnum(String name) {
    String caseStatusEnumPre = name.substring(0, name.indexOf("_"));
    return CaseProgressEnum.valueOf(caseStatusEnumPre);
  }
  
  /**
   * 根据状态前缀获取进度枚举值
   * 
   * @param caseStatusEnum
   * @return
   */
  public static CaseProgressEnum getCaseProgressEnum(CaseStatusEnum caseStatusEnum) {
    String name = caseStatusEnum.name();
    return getCaseProgressEnum(name);
  }

  /**
   * 根据进度查询状态
   */
  public static List<CaseStatusEnum> queryCaseStatusEnumLst(CaseProgressEnum caseProgressEnum) {
    List<CaseStatusEnum> result = new ArrayList<CaseStatusEnum>();


    EnumSet<CaseStatusEnum> caseStatusEnumSet = EnumSet.allOf(CaseStatusEnum.class);
    for (CaseStatusEnum tmp : caseStatusEnumSet) {
      if (tmp.name().startsWith(caseProgressEnum.name())) {
        result.add(tmp);
      }
    }
    return result;
  }

}
