package com.beiming.odr.referee.enums;

/**
 * @Description: 发送短信类型枚举
 * @Author: caiwei
 * @Date: 2019/1/10
 */
public enum SendSMSTypeEnum {

  NORMAL_SEND("正常发送", 0), ALL_NOT_SEND("全都不发送", 1), LITIGANT_NOT_SEND("当事人少发", 2);

  private String name;

  private Integer code;

  public String getName() {
    return name;
  }

  public Integer getCode() {
    return code;
  }

  SendSMSTypeEnum(String name, Integer code) {
    this.name = name;
    this.code = code;
  }

  public static SendSMSTypeEnum getSendSMSTypeEnumByCode(Integer code) {
    SendSMSTypeEnum[] enums = SendSMSTypeEnum.values();
    for (SendSMSTypeEnum smsTypeEnum : enums) {
      if (smsTypeEnum.code == code) {
        return smsTypeEnum;
      }
    }
    return null;
  }

}