/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.SaveJudicialConfirmBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveProtocolBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.WaitSignDocumentReqDTO;
import com.beiming.odr.referee.dto.responsedto.DocumentListResDTO;
import com.beiming.odr.referee.dto.responsedto.JudicialConfirmBookResDTO;
import com.beiming.odr.referee.dto.responsedto.MediatorHelpPersonResDTO;
import com.beiming.odr.referee.dto.responsedto.ProtocolBookResDTO;
import com.beiming.odr.referee.dto.responsedto.UnanimityMediationSchemeResDTO;
import com.beiming.odr.referee.dto.responsedto.WaitSignDocumentResDTO;
import com.beiming.odr.referee.enums.DocumentTypeEnum;
import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/referee/document"})
@RestController
public interface DocumentApi {
    @RequestMapping(value={"/checkDocumentExist"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<Boolean> checkDocumentExist(@RequestParam(name="id") Long var1);

    @RequestMapping(value={"/getProtocolBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<ProtocolBookResDTO> getProtocolBook(@RequestParam(name="caseId") Long var1, @RequestBody DocumentTypeEnum var2);

    @RequestMapping(value={"/getTempProtocolBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<ProtocolBookResDTO> getTempProtocolBook(@RequestParam(name="caseId") Long var1, @RequestBody DocumentTypeEnum var2);

    @RequestMapping(value={"/saveProtocolBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<ProtocolBookResDTO> saveProtocolBook(@RequestBody @Valid SaveProtocolBookReqDTO var1);

    @RequestMapping(value={"/saveRecordBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<ProtocolBookResDTO> saveRecordBook(@RequestBody @Valid SaveProtocolBookReqDTO var1);

    @RequestMapping(value={"/saveDissentBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<ProtocolBookResDTO> saveDissentBook(@RequestBody @Valid SaveProtocolBookReqDTO var1);

    @RequestMapping(value={"/sendProtocolBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult sendProtocolBook(@RequestParam(name="documentId") Long var1);

    @RequestMapping(value={"/getMediationScheme"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<UnanimityMediationSchemeResDTO> getMediationScheme(@RequestParam(name="caseId") Long var1);

    @RequestMapping(value={"/savePromiseBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult savePromiseBook(@RequestBody SavePromiseBookReqDTO var1);

    @RequestMapping(value={"/refuseDocument"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<Long> refuseDocument(@RequestParam(name="documentId") Long var1, @RequestParam(name="confirmUserId") Long var2, @RequestParam(name="userName") String var3);

    @RequestMapping(value={"/getMediationIdByCaseId"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<Long> getMediationIdByCaseId(@RequestParam(name="caseId") Long var1);

    @RequestMapping(value={"/getJudicialConfirmBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<JudicialConfirmBookResDTO> getJudicialConfirmBook(@RequestParam(name="caseId") Long var1, @RequestBody DocumentTypeEnum var2, @RequestParam(name="isNew") Integer var3);

    @RequestMapping(value={"/saveJudicialConfirmBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<Long> saveJudicialConfirmBook(@RequestBody SaveJudicialConfirmBookReqDTO var1);

    @RequestMapping(value={"/sendJudicialConfirmBook"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<Long> sendJudicialConfirmBook(@RequestBody SaveJudicialConfirmBookReqDTO var1);

    @RequestMapping(value={"/getCaseIdByDocId"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<Long> getCaseIdByDocId(@RequestParam(name="id") Long var1);

    @RequestMapping(value={"/getWaitSignDocumentList"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<PageInfo<WaitSignDocumentResDTO>> getWaitSignDocumentList(@RequestBody WaitSignDocumentReqDTO var1);

    @RequestMapping(value={"/getAllDocumentByCaseId"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<ArrayList<DocumentListResDTO>> getAllDocumentByCaseId(@RequestParam(name="caseId") Long var1);

    @RequestMapping(value={"/getMediatorHelpPersonByCaseId"}, method={RequestMethod.POST}, produces={"application/json"})
    public DubboResult<ArrayList<MediatorHelpPersonResDTO>> getMediatorHelpPersonByCaseId(@RequestParam(name="caseId") Long var1);
}

