package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.odr.referee.constant.RefereeApiConst;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingInviteReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawAttachmentUpFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationSuccessFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateTimeReqDTO;
import com.beiming.odr.referee.dto.requestdto.VideoPrivateChatReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingVideoResDTO;
import com.beiming.odr.referee.dto.responsedto.InviteWatchResDTO;
import com.beiming.odr.referee.dto.responsedto.VideoPrivateChatResDTO;


@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/caseMeeting")
@RestController
public interface CaseMeetingApi {

  /**
   * 保存会议记录
   *
   * @param caseMeetingSaveReqDTO
   * @return
   */
  @RequestMapping(value = "/caseMeetingSave", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  @SuppressWarnings("rawtypes")
  DubboResult caseMeetingSave(@RequestBody @Valid CaseMeetingSaveReqDTO caseMeetingSaveReqDTO);

  /**
   * 视频记录
   *
   * @param caseMeetingIdReqDTO
   *
   */
  @RequestMapping(value = "/getVideo", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CaseMeetingVideoResDTO>> getVideo(
      @RequestBody @Valid CaseMeetingIdReqDTO caseMeetingIdReqDTO,
      @RequestParam(name = "cType") String cType);

  /**
   * 邀请观摩人
   *
   * @param caseMeetingInvite
   * @return
   */
  @RequestMapping(value = "/sendViewSms", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  @SuppressWarnings("rawtypes")
  DubboResult sendViewSms(@RequestBody @Valid CaseMeetingInviteReqDTO caseMeetingInvite);

  /**
   * 调解 会议视频 保存上传文件
   *
   * @return
   */
  @RequestMapping(value = "/saveUpFile", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult saveUpFile(@RequestBody @Valid LawAttachmentUpFileReqDTO lawAttachmentUpFileReqDTO);

  /**
   * 同过案件id查询调解会议记录
   *
   * @param caseId
   * @return
   */
  @RequestMapping(value = "/queryCaseMeetingList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<CaseMeetingListResDTO>> queryCaseMeetingList(
      @RequestParam(name = "caseId") Long caseId, @RequestParam(name = "userId") Long userId);

  /**
   * 会议开始时间更新
   *
   * @param meetingId
   * @return
   */
  @RequestMapping(value = "/updateMeetingStartTime", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> updateMeetingStartTime(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_IS_NULL) @RequestParam(
          name = "meetingId") Long meetingId);

  /**
   * 会议结束时间更新
   * 
   * @param updateTimeReqDTO
   * @return
   */
  @RequestMapping(value = "/updateMeetingEndTime", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult updateMeetingEndTime(@RequestBody UpdateTimeReqDTO updateTimeReqDTO);

  /**
   * 通过邀请码生成对应信息
   *
   * @param inviteCode
   * @param userId
   * @param userName
   * @return
   */
  @RequestMapping(value = "/inviteWatching", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<InviteWatchResDTO> inviteWatching(
      @RequestParam(name = "inviteCode") String inviteCode,
      @RequestParam(name = "userId", required = false) String userId,
      @RequestParam(name = "userName", required = false) String userName);

  /**
   * 调解失败 给调度用
   *
   * @return
   */
  @RequestMapping(value = "/mediationFailTask", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult mediationFailTask(
      @RequestBody @Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 私聊视频
   * 
   * @param videoPrivateChatReqDTO
   * @return
   */
  @RequestMapping(value = "/meetingVideoPrivateChat", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<VideoPrivateChatResDTO> meetingVideoPrivateChat(
      @RequestBody @Valid VideoPrivateChatReqDTO videoPrivateChatReqDTO);

}
