package com.beiming.odr.referee.api;

import com.beiming.odr.referee.dto.requestdto.SignatureConfirmInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.SignatureConfirmInfoResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmAllReqDTO;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmPerReqDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmAllResDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmPerResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;


/**
 * 文书签名状态API
 * 
 * @author DJQ 2018年6月27日
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/clerkConfirm")
@RestController
public interface ClerkConfirmApi {

  /**
   * 查询某用户对调解文书的签名状态
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/getMediationClerkConfirm", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ClerkConfirmPerResDTO> getMediationClerkConfirm(
      @RequestBody @Valid ClerkConfirmPerReqDTO reqDTO);

  /**
   * 查询调解文书的各方签名状态
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/getAllMediationClerkConfirm", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<ClerkConfirmAllResDTO>> getAllMediationClerkConfirm(
      @RequestBody @Valid ClerkConfirmAllReqDTO reqDTO);

  /**
   * 校验用户签名权限
   * 
   * @param userId
   * @param documentId
   * @return
   */
  @RequestMapping(value = "/judgeSignaturePermission", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ClerkConfirmPerResDTO> judgeSignaturePermission(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL) @RequestParam(
          name = "userId") Long userId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_DOCUMENT_ID_NULL) @RequestParam(
          name = "documentId") Long documentId);


  /**
   * 签名确认结果信息
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/signatureConfirmInfo", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<SignatureConfirmInfoResDTO>> signatureConfirmInfo(
      @RequestBody @Valid SignatureConfirmInfoReqDTO reqDTO);

}
