package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.LawCaseRelationReqDTO;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.odr.referee.constant.RefereeApiConst;


/**
 * @Description: 案件同步
 * @Author: caiwei
 * @Date: Created 2018-06-20
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationCaseRelationOrg")
@RestController
public interface MediationCaseRelationOrgApi {

  /**
   * (湖州环资)案件同步到多单位
   */
  @RequestMapping(value = "/insertCaseRelationOrgList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult insertCaseRelationOrgList(@RequestBody List<LawCaseRelationReqDTO> reqDTOList);

}
