package com.beiming.odr.referee.api;

import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationRecordGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSendResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;

/**
 * 调解笔录API
 *
 * @author DJQ 2018年6月26日
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/mediationDocRecord")
@RestController
public interface MediationDocRecordApi {

  /**
   * 发送调解笔录
   *
   * @return
   */
  @RequestMapping(value = "/sendMediationRecord", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationRecordSendResDTO> sendMediationRecord(
      @RequestBody @Valid MediationRecordSendReqDTO reqDTO);

  /**
   * 获取调解笔录(最新或备份)
   *
   * @return
   */
  @RequestMapping(value = "/getMediationRecord", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationRecordGetResDTO> getMediationRecord(
      @RequestBody @Valid MediationRecordGetReqDTO reqDTO,
      @RequestParam(name = "isNew") Boolean isNew);

  /**
   * 保存调解笔录
   *
   * @return
   */
  @RequestMapping(value = "/saveMediationRecord", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationRecordSaveResDTO> saveMediationRecord(
      @RequestBody @Valid MediationRecordSaveReqDTO reqDTO);

}
