package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;
import com.beiming.odr.referee.dto.requestdto.ProgressAddReqDTO;
import com.beiming.odr.referee.dto.requestdto.ProgressQueryReqDTO;
import com.beiming.odr.referee.dto.responsedto.ProgressAddResDTO;
import com.beiming.odr.referee.dto.responsedto.ProgressQueryResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 进度信息API
 *
 * @author DJQ
 *
 */
@Valid
@RequestMapping(RefereeApiConst.URL_PREFIX + "/progressInfo")
@RestController
public interface ProgressInfoApi {

  /**
   * 新增进度接口(Env 环资)
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/addEnvAppraisaProgress", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ProgressAddResDTO> addEnvAppraisaProgress(@RequestBody ProgressAddReqDTO reqDTO);



  /**
   * 新增自定义进度接口
   *
   * @param reqDTO
   * @return Long
   */
  @RequestMapping(value = "/addCustomAppraisaProgress", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Integer> addCustomAppraisaProgress(@RequestBody ProgressAddReqDTO reqDTO);



  /**
   * 进度列表查询接口(Env 环资)
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "/queryEnvAppraisaProgress", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<ProgressQueryResDTO>> queryEnvAppraisaProgress(
      @RequestBody @Valid ProgressQueryReqDTO reqDTO);

}
