package com.beiming.odr.referee.api;
/**
 * 
 * @author ljf
 *
 */

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.constant.RefereeApiConst;

@RequestMapping(RefereeApiConst.URL_PREFIX + "/refereeTask")
@RestController
public interface RefereeTaskApi {
  // No objection seven day confirm
  /**
   * 无异议调解方案机制--7天无异议默认为 达成调解协议
   * 
   * @return
   */
  @RequestMapping(value = "/confirmBySevenDaysWithoutObjection", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> confirmBySevenDaysWithoutObjection();

  /**
   * 超期案件自动失败
   * 
   * @return
   */
  @RequestMapping(value = "/overdueAutomaticFailure", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> overdueAutomaticFailure();

  /**
   * 批处理更新时间和状态
   * 
   * @return
   */
  @RequestMapping(value = "/updateMeetingEnd", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> updateMeetingEnd();

  /**
   * 案件监控调度队列存储短信
   * 
   * @return
   */
  @RequestMapping(value = "/caseMonitorMessage", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> caseMonitorMessage();

  /**
   * 案件监控调度获取队列可发送短信
   * 
   * @return
   */
  @RequestMapping(value = "/caseMonitorQueueList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Boolean> caseMonitorQueueList();
}
