package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.AddScavengerMeetingPersonReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddScavengerMeetingReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingInviteReqDTO;
import com.beiming.odr.referee.dto.requestdto.MeetingDetailReqDTO;
import com.beiming.odr.referee.dto.requestdto.MeetingInviteCodeReqDTO;
import com.beiming.odr.referee.dto.requestdto.ScavengerMeetingListReqDTO;
import com.beiming.odr.referee.dto.requestdto.VideoPrivateChatReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationRoomResDTO;
import com.beiming.odr.referee.dto.responsedto.LitigantMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingAndFilesDetailResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingDetailResDTO;
import com.beiming.odr.referee.dto.responsedto.ScavengerMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.VideoPrivateChatResDTO;
import com.beiming.odr.referee.constant.RefereeApiConst;


/**
 * 环资API
 * 
 * @author qsh
 * @date 2019年4月25日
 */
@RequestMapping(RefereeApiConst.URL_PREFIX + "/scavengerMeeting")
@RestController
public interface ScavengerMeetingApi {

  /**
   * 保存会议
   * 
   * @param addScavengerMeetingReqDTO
   * @return
   */
  @RequestMapping(value = "/addMeeting", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<AddMediationRoomResDTO> addMeeting(
      @RequestBody AddScavengerMeetingReqDTO addScavengerMeetingReqDTO);

  /**
   * 查询会议列表
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "/queryMediationMeetingList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<ScavengerMeetingListResDTO>> queryMediationMeetingList(
      @RequestBody ScavengerMeetingListReqDTO dto);

  /**
   * 会议详情
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "/getMeetingDetail", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MeetingAndFilesDetailResDTO> getMeetingDetail(@RequestBody MeetingDetailReqDTO dto);

  /**
   * 通过邀请码查询会议
   * 
   * @param inviteCode
   * @return
   */
  @RequestMapping(value = "/getMediationMeetingCode", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationMeetingRoomResDTO> getMediationMeetingCode(
      @RequestBody MeetingInviteCodeReqDTO inviteCode);

  /**
   * 通过邀请码查询参加会议人员
   * 
   * @param inviteCode
   * @return
   */
  @RequestMapping(value = "/getMediationMeetingUserCode", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MediationRoomUserInfoResDTO> getMediationMeetingUserCode(
      @RequestBody MeetingInviteCodeReqDTO inviteCode);

  /**
   * 邀请观摩人
   *
   * @param caseMeetingInvite
   * @return
   */
  @RequestMapping(value = "/inviteVisitors", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult inviteVisitors(@RequestBody @Valid CaseMeetingInviteReqDTO caseMeetingInvite);

  /**
   * 案件会议及参会人员信息
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "/getCaseMeetingList", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<ArrayList<MeetingDetailResDTO>> getCaseMeetingList(@RequestBody CaseIdReqDTO dto);

  /**
   * 通过邀请码查询会议及参会信息
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "/getMeetingDetailResDTO", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<MeetingDetailResDTO> getMeetingDetailResDTO(@RequestBody MeetingDetailReqDTO dto);

  /**
   * 获取当事人会议列表
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "/queryMeetingPersonnel", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<PageInfo<LitigantMeetingListResDTO>> queryLitigantMeetingList(
      @RequestBody ScavengerMeetingListReqDTO dto);

  /**
   * 私聊视频
   * 
   * @param videoPrivateChatReqDTO
   * @return
   */
  @RequestMapping(value = "/mediationMeetingVideoPrivateChat", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<VideoPrivateChatResDTO> mediationMeetingVideoPrivateChat(
      @RequestBody @Valid VideoPrivateChatReqDTO dto);

  /**
   * 预约视频会议数量
   * 
   * @return
   */
  @RequestMapping(value = "/scavengerMeetingCount", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<Integer> scavengerMeetingCount();

  /**
   * 添加会议人员
   * 
   * @param addScavengerMeetingReqDTO
   * @return
   */
  @RequestMapping(value = "/addMeetingPersonnel", method = RequestMethod.POST,
      produces = MediaType.APPLICATION_JSON_VALUE)
  DubboResult<AddMediationRoomResDTO> addMeetingPersonnel(
      @RequestBody AddScavengerMeetingPersonReqDTO addScavengerMeetingPersonReqDTO);

}
