package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt 2019-09-10
 *
 * 案件id
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseAcceptReqDTO implements Serializable {

  private static final long serialVersionUID = 6056042729850330362L;
  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long caseId;

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private Long userId;

  @NotBlank(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private String userName;

}
