package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 区域管理员不受理
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CaseRejectCaseReqDTO implements Serializable {

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long caseId;

  //原因
  private String reason;

  //说明
  private String desc;

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private Long userId;

  @NotBlank(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private String userName;

}
