package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt on 2019/9/8.
 *
 * 案件转移请示参
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CaseTransferReqDTO implements Serializable {

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  @Min(value = 1, message = "值非法")
  private Long caseId;

  ///转移后地区  不需要传,自己查询
  //@NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private String toAreaName;

  //转移后地区的code   记录到转移表
  //@NotBlank(message = RefereeValidateMessage.PARAMETER_IS_NULL)
  private String toAreaCode;

  //转移原因
  private String reason;

  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private Long userId;

  @NotBlank(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private String userName;


}
