package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.beiming.odr.referee.constant.RefereeValidateMessage;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 查询某用户对调解文书的签名状态请求参数
 * 
 * @author DJQ 2018年6月27日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ClerkConfirmPerReqDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL)
  private Long userId;
  @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL)
  private Long lawCaseId;
  @NotNull(message = RefereeValidateMessage.PARAMETER_DOCUMENT_ID_NULL)
  private Long documentId;
  private String userType;

}
