package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 调解进度新增请求参数
 * 
 * @author DJQ
 *
 */
@Data
public class ProgressAddReqDTO  implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  /**
   * 创建人ID
   */
  private Long createUserId;

  /**
   * 进度状态
   */
  @NotNull(message = "进度状态不允许为空")
  private String progressStatus;

  /**
   * 进度内容
   */
  @NotNull(message = "进度内容不允许为空")
  private String progressContent;

  /**
   * 案号
   */
  private String caseNo;

  /**
   * 类型(类型（dossier卷宗表/law_case案件表/law_suit诉讼表)
   */
  @NotNull(message = "subjectType不允许为空")
  private String subjectType;

  /**
   * 对应表主键id
   */
  @NotNull(message = "subjectId不允许为空")
  private Long subjectId;

  /**
   * 名称
   */
  private String subjectName;

  /**
   * JSON
   */
  private String progressJson; // 这个是房间json
  
  /**
   * remark
   */
  private String remark;

  private Long id;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;



}
