package com.beiming.odr.referee.dto.requestdto;


import com.beiming.odr.referee.dto.responsedto.ReAppealHeaderResDTO;
import com.beiming.odr.referee.dto.responsedto.ReOrganizationResDTO;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

@Data
public class ReAppealFlowSaveReqDTO implements Serializable {

  private static final long serialVersionUID = 701189089298287714L;


  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 工单id（对应appeal_header表的id）
   */
  private Long appealId;

  /**
   * 处理人id
   */
  private Long userId;

  /**
   * 处理人名称
   */
  private String userName;

  /**
   * 处理机构id
   */
  private Long fromOrgId;

  /**
   * 处理机构名称
   */
  private String fromOrgName;

  /**
   * 处理诉求机构类型
   */
  private String fromAppealOrgType;

  /**
   * 处理机构区域
   */
  private String fromOrgAreaCode;

  /**
   * 处理机构等级
   */
  private Integer fromOrgLevel;

  /**
   * 处理前状态
   */
  private String fromStatus;

  /**
   * 转入机构id
   */
  private Long toOrgId;

  /**
   * 转入机构名称
   */
  private String toOrgName;

  /**
   * 转入诉求机构类型
   */
  private String toAppealOrgType;

  /**
   * 转入机构区域
   */
  private String toOrgAreaCode;

  /**
   * 转入机构等级
   */
  private Integer toOrgLevel;

  /**
   * 处理后状态
   */
  private String toStatus;

  /**
   * 转入人员id
   */
  private Long toUserId;

  /**
   * 转入人员名称
   */
  private String toUserName;

  /**
   * 步骤code
   */
  private String activityCode;

  /**
   * 步骤名称
   */
  private String activityName;

  /**
   * 操作内容
   */
  private String operateContent;

  /**
   * 处理时间
   */
  private Date operateTime;

  /**
   * 处理意见
   */
  private String operateOpinion;

  /**
   * 附件
   */
  private ReFileReqDTO file;

  public ReAppealFlowSaveReqDTO(TransferRequestDTO transferDto, ReAppealHeaderResDTO appeal, ReOrganizationResDTO toOrg, String orgAreaCode) {
    this.createUser = transferDto.getUserName();
    this.createTime = new Date();
    this.appealId = transferDto.getAppealId();
    this.userId = transferDto.getUserId();
    this.userName = transferDto.getUserName();
    this.fromOrgId = appeal.getProcessOrgId();
    this.fromOrgName = appeal.getProcessOrgName();
    this.fromAppealOrgType = appeal.getProcessAppealOrgType();
    this.fromOrgAreaCode = appeal.getProcessOrgAreaCode();
    this.fromStatus = appeal.getAppealStatus();
    this.toOrgId = toOrg.getId();
    this.toOrgName = toOrg.getName();
    this.toAppealOrgType = toOrg.getAppealOrgTypeCode();
    this.toOrgAreaCode = orgAreaCode;
    this.toOrgLevel = toOrg.getGradeLevel();
    this.toStatus = transferDto.getToStatus();
    this.toUserId = transferDto.getToUserId();
    this.toUserName = transferDto.getUserName();
    this.activityCode = transferDto.getActivityCode();
    this.operateTime = new Date();
    this.operateOpinion = transferDto.getOperateOpinion();
    this.operateContent = transferDto.getOperateContent();
    ReFileRequestDTO fileDTO = transferDto.getFile();
    if (fileDTO != null) {
      ReFileReqDTO fileReqDTO = new ReFileReqDTO();
      BeanUtils.copyProperties(fileDTO, fileReqDTO);
      fileReqDTO.setFileType(fileDTO.getFileType() == null ? null : fileDTO.getFileType().name());
      this.file = fileReqDTO;
    }
    if (!StringUtils.isEmpty(transferDto.getOperateContent())) {
      String activityCode = transferDto.getActivityCode();
      String operateContent = null;
      if ("ASSIGN_ORG".equals(activityCode)) {
        operateContent = "分配给" + toOrg.getName();
      } else if ("SUBMIT_HIGHER".equals(activityCode)) {
        operateContent = "提交给" + toOrg.getName();
      } else if ("DOWN_AREA".equals(activityCode)) {
        operateContent = "下派给" + toOrg.getName();
      } else if ("SUBMIT_PLATFORM".equals(activityCode)) {
        operateContent = "提交总平台 " + toOrg.getName();
      } else if ("TRANSFER_AREA".equals(activityCode)) {
        operateContent = "转移给" + toOrg.getName();
      }
      if (StringUtils.isNotBlank(operateContent)) {
        this.activityName = operateContent;
      } else {
        this.activityName = transferDto.getActivityName();
      }
    }

  }
  
  
}
