package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt 2019-09-10
 *
 * 案件id
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ReAppealStatusUpdateReqDTO implements Serializable {

  private static final long serialVersionUID = 6056042729850330362L;

  @NotNull(message = "诉求id不能为空")
  @Min(value = 1, message = "值非法")
  private Long appealId;

  @NotNull(message = "状态不能为空")
  private String appealStatus;

  @NotNull(message = "状态名称不能为空")
  private String appealStatusName;

  private String updateUser;
  
  /**
   * 标志是否办结审核通过，默认为false
   */
  private String isEndAuditPass;
  
  /**
   * 原因类型
   */
  private String reasonType;

  /**
   * 详细原因
   */
  private String detailReason;


  public ReAppealStatusUpdateReqDTO(TransferRequestDTO transferDto) {
    this.appealId = transferDto.getAppealId();
    this.appealStatus = transferDto.getToStatus();
    this.appealStatusName = transferDto.getToStatusName();
    this.updateUser = transferDto.getUserName();
    this.isEndAuditPass = transferDto.getIsEndAuditPass();
    this.reasonType = transferDto.getReasonType();
    this.detailReason = transferDto.getDetailReason();
  }
}
