package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import com.beiming.odr.referee.enums.SuitTypeEnums;
import lombok.Data;

@Data
public class SaveSuitReqDTO implements Serializable {

  private static final long serialVersionUID = 2204757114565607086L;

  /**
   * 诉讼或司法确认
   */
  private SuitTypeEnums type;
  /**
   * 法院名称
   */
  private String courtName;
  /**
   * 法院编码
   */
  private String courtCode;
  /**
   * 诉讼类型
   */
  private String caseType;
  /**
   * 诉讼类型名称
   */
  private String caseTypeName;
  /**
   * 申请人
   */
  private List<SuitUserReqDTO> applicants;
  /**
   * 被申请人
   */
  private List<SuitUserReqDTO> respondents;
  /**
   * 案由编码
   */
  private String causeCode;
  /**
   * 案由
   */
  private String causeName;
  /**
   * 申请人诉求
   */
  private String appeal;
  /**
   * 纠纷类型
   */
  private String disputeType;
  /**
   * 纠纷类型code
   */
  private String disputeTypeCode;
  /**
   * 案件材料
   */
  private List<SuitAttachmentReqDTO> attachments;

  private Long lawCaseId;

  private Float targetAmount;
  
  private Long userId;

}
